/* global jQuery:true */
/* global dittyAdminVars:true */
/* global console:true */

// @codekit-append 'admin/general.js';
// @codekit-append 'admin/class-ditty-settings.js';
// @codekit-append 'admin/class-ditty-extension.js';
// @codekit-append 'admin/ditty-extensions.js';
// @codekit-append 'admin/ditty-displays.js';
// @codekit-append 'admin/ditty-wizard.js';

jQuery(function($) {
	// Setup strict mode
	(function() {
		'use strict';

		$('#poststuff').trigger('ditty_init_fields');
		$('#ditty-settings').ditty_settings();
	})();
});


/* global jQuery:true */

jQuery( function( $ ) {
	
	// Setup strict mode
	(function() {

		"use strict";
		
		$( '#menu-posts-ditty .wp-submenu li' ).each( function() {
			var $item = $( this ),
					$link = $item.children( 'a' );
					
			if ( $link.length ) {
				var href = $link[0].href,
						parts = href.split( '=' ),
						lastPart = parts[parts.length-1];
				
				$item.addClass( lastPart );
			}
		} );

	}() );
	
} );

/**
 * Ditty Settings
 *
 * @since		3.0
 * @return	null
*/

(function ($) {
  'use strict';

  var defaults = {
  };

  var Ditty_Settings = function ( elmt, options ) {
	  
    this.elmt							= elmt;
    this.settings					= $.extend( {}, defaults, $.ditty_settings.defaults, options );
    this.$elmt						= $( elmt );
    this.$form						= this.$elmt.find( '.ditty-settings__form' );
		this.$panels					= this.$elmt.find( '.ditty-settings__panels' );
		this.saveBtns					= this.$elmt.find( '.ditty-settings__save' );
		this.tabs							= this.$elmt.find( '.ditty-settings__tab' );
		this.$notice_update 	= this.$elmt.find( '.ditty-notification--updated' );
		this.$notice_error 		= this.$elmt.find( '.ditty-notification--error' );
		this.$notice_warning 	= this.$elmt.find( '.ditty-notification--warning' );
		this.initData					= null;
		this.url							= window.location.href;
    this._init();
  };


  Ditty_Settings.prototype = {

    /**
		 * Initialize the data list
		 *
		 * @since		3.0
		 * @return	null
		*/
    _init: function () {

			// Initialize the slider
			this._initSlider();
      
      // Add listeners
			$( 'body' ).on( 'ditty_field_clone_update', { self: this }, this._enableSettingsUpdates );
			this.saveBtns.on( 'click', { self: this }, this._submitForm );
			this.$panels.on( 'ditty_slider_init', { self: this }, this._sliderInit );
			this.$panels.on( 'ditty_slider_before_slide_update', { self: this }, this._beforeSlideUpdate );
			this.$form.on( 'keyup change', 'input[type="text"], input[type="number"], textarea, select', { self: this }, this._checkUpdates );
			this.$form.on( 'click', 'input[type="radio"], input[type="checkbox"]', { self: this }, this._checkUpdates );
			this.$form.on( 'ditty_input_wysiwyg_update', '.ditty-input--wysiwyg', { self: this }, this._checkUpdates );
			this.$form.on( 'click', '.ditty-default-layout-install', { self: this }, this._installLayout );
			this.$form.on( 'click', '.ditty-default-display-install', { self: this }, this._installDisplay );
			
			this.$form.on( 'click', '.ditty-export-posts input[type="checkbox"]', { self: this }, this._exportCheckboxClick );
			
			if ( this.$elmt.hasClass( 'dynamic-tabs' ) ) {
				this.tabs.on( 'click', { self: this }, this._tabClick );
			}
			if ( this.$elmt.hasClass( 'dynamic-tabs' ) && this.url.indexOf( "#" ) > 0 ) {
				var activePanel = this.url.substring( this.url.indexOf( "#" ) + 1 );
				this._activatePanel( activePanel );
			}
    },
		
		/**
		 * Initialize the slider
		 *
		 * @since    3.0.13
		 * @return   null
		*/
		_initSlider: function () {	
			if ( this.$elmt.hasClass( 'dynamic-tabs' ) ) {
				var initPanel = this.$panels.data( 'init_panel' );
				this.$panels.ditty_slider( {
					transition						: 'fade',
					transitionEase				:	'linear',
					transitionSpeed				: 0,
					heightSpeed						: 0,
					initTransition				:	'fade',
					initTransitionEase		:	'linear',
					initTransitionSpeed		:	0,
					initHeightEase				:	'linear',
					initHeightSpeed				:	0,
					touchSwipe						: false,
					slidesEl							: '.ditty-settings__panel',
					slideId								: ( '' !== initPanel ) ? initPanel : false
				} );
			}
		},
		
		/**
		 * Slider init
		 *
		 * @since    3.0
		 * @return   null
		*/
		_sliderInit: function( e ) {
			var self = e.data.self;
			self.initData = self.$form.serialize();
		},
		
		/**
		 * Before slide update
		 *
		 * @since    3.0
		 * @return   null
		*/
		_beforeSlideUpdate: function( e, index, slide ) {
			var self = e.data.self;
			self._initFields( slide.$elmt );
			self.$elmt.find( '.ditty-settings__tab' ).removeClass( 'active' );
			self.$elmt.find( '.ditty-settings__tab[data-panel="' + slide.id + '"]' ).addClass( 'active' );
		},
		
		/**
		 * Preview button add updates class
		 *
		 * @since    3.0
		 * @return   null
		*/
		_enableSettingsUpdates: function( e ) {
			var self = ( e ) ? e.data.self : this;
			self.saveBtns.addClass( 'has-updates' );
			//self.notice_warning.slideDown();
		},
		
		/**
		 * Preview button remove updates class
		 *
		 * @since    3.0
		 * @return   null
		*/
		_disableSettingsUpdates: function() {
			this.saveBtns.removeClass( 'has-updates' );
		},
		
		/**
		 * Check for updates
		 *
		 * @since    3.0
		 * @return   null
		*/
		_checkUpdates: function( e ) { 
			var self = e ? e.data.self : this;
			var currentData = self.$form.serialize();
			if ( currentData !== self.initData ) {
				self._enableSettingsUpdates();
			}	else {
				self._disableSettingsUpdates();
			}
		},
		
		/**
		 * Initialize dynamic fields
		 *
		 * @since    3.0
		 * @return   null
		*/
		_initFields: function ( $fields ) {
			$fields.find( '.ditty-data-list' ).ditty_ui_data_list();
			$fields.trigger( 'ditty_init_fields' );
			$.protip( {
				defaults: {
					position: 'top',
					size: 'small',
					scheme: 'black',
					classes: 'ditty-protip'
				}
			} );
		},
		
		/**
		 * Show or hide post types
		 *
		 * @since    3.0
		 * @return   null
		*/
		_togglePostTypes: function () {
			if ( $( 'input[name="ditty_layout_ui"]' ).length ) {
				var layoutUiVal = $( 'input[name="ditty_layout_ui"]:checked' ).val(),
						$layoutMenu = $( '#adminmenu .wp-submenu > li > a[href="edit.php?post_type=ditty_layout"]' );
				if ( 'disabled' === layoutUiVal ) {
					$layoutMenu.hide();
				} else {
					$layoutMenu.css( 'display', 'block' );
				}
			}
			if ( $( 'input[name="ditty_display_ui"]' ).length ) {
				var displayUiVal = $( 'input[name="ditty_display_ui"]:checked' ).val(),
						$displayMenu = $( '#adminmenu .wp-submenu > li > a[href="edit.php?post_type=ditty_display"]' );
				if ( 'disabled' === displayUiVal ) {
					$displayMenu.hide();
				} else {
					$displayMenu.css( 'display', 'block' );
				}
			}
		},
		
		/**
		 * Activate a panel
		 *
		 * @since    3.0.13
		 * @return   null
		*/
		_activatePanel: function( panelId ) {
			var $tab = this.$elmt.find( '.ditty-settings__tab[data-panel="' + panelId + '"]' );
			if ( ! $tab.length ) {
				return false;
			}

			this.$elmt.find( '.ditty-settings__tab' ).removeClass( 'active' );
			$tab.addClass( 'active' );
			
			this.$panels.ditty_slider( 'showSlideById', panelId );
		},

		/**
		 * Listen for a tab click
		 *
		 * @since    3.0
		 * @return   null
		*/
		_tabClick: function( e ) {
			e.preventDefault();
			var self				= e.data.self,
					$tab				= $( e.target ).is( 'a' ) ? $( e.target ) : $( e.target ).parent( 'a' ),
					slideId 		= $tab.data( 'panel' ),
					$currentTab	= self.$elmt.find( '.ditty-settings__tab.active' );
					
			if ( $currentTab === $tab ) {
				return false;
			}
			
			var newUrl;			
			if ( slideId ) {
				var hash = '#' + slideId;
				newUrl = self.url.split("#")[0] + hash;
			} else {
				newUrl = self.url.split("#")[0];
			} 
			history.replaceState( null, null, newUrl );
			
			self._activatePanel( slideId );
		},
		
		/**
		 * Update inputs after save and sanitize
		 *
		 * @since    3.0
		 * @return   null
		*/
		_upateInputs: function( updates ) {
			$.each( updates, function( inputName, updatedValue ) {
				if ( $( 'input[name="' + inputName + '"]' ).length ) {
					$( 'input[name="' + inputName + '"]' ).val( updatedValue );
				}
			} );
		},
		
		/**
		 * Submit updates
		 *
		 * @since    3.0
		 * @return   null
		*/
		_submitForm: function( e ) {
			e.preventDefault();
			var self = e.data.self;

			if ( self.$elmt.hasClass( 'updating' ) ) {
				return false;
			}
			
			self.$elmt.trigger( 'ditty_pre_save_fields' );
			self.$elmt.addClass( 'updating' );
			self.saveBtns.text( dittyAdminVars.adminStrings.settingsSaving );
			
			self.$form.ajaxSubmit( {
				url				: dittyAdminVars.ajaxurl,
				type			: 'post',
				dataType	: 'json',
				data			: {
					action		: 'ditty_settings_save',
					security	: dittyAdminVars.security
				},
				success: function( data ) {
					if ( data.input_updates ) {
						self._upateInputs( data.input_updates );
					}
					self.initData = self.$form.serialize();
					self.saveBtns.text( dittyAdminVars.adminStrings.settings_updated );
					setTimeout( function() {
						self.saveBtns.text( dittyAdminVars.adminStrings.settings_save );
					}, 2000 );
					self.$elmt.removeClass( 'updating' );
					self._disableSettingsUpdates();

					//self.$notice_update.slideDown();
					
					// Check the post types display
					self._togglePostTypes();
				}
			} );
		},
		
		/**
		 * Install a layout
		 *
		 * @since    3.0
		 * @return   null
		*/
		_installLayout: function( e ) { 
			e.preventDefault();
			var self 			= e.data.self,
					$button 	= $( e.target ).is( 'button' ) ? $( e.target ) : $( e.target ).parents( 'button' ),
					$icon			= $button.find( 'i' ),
					iconClass	= $icon.attr( 'class' );
					
			if ( $button.hasClass( 'updating' ) ) {
				return false;
			}
			$button.addClass( 'updating' );
			$icon.attr( 'class', dittyAdminVars.updateIcon );
			
			var data = {
				action					: 'ditty_install_layout',
				layout_template : $button.data( 'layout_template' ),
				layout_version 	: $button.data( 'layout_version' ),
				security				: dittyAdminVars.security
			};
			$.post( dittyAdminVars.ajaxurl, data, function( response ) {
				$icon.attr( 'class', iconClass );
				self.$elmt.removeClass( 'updating' );	
				if ( response ) {
					$button.replaceWith( response.button );
				}
			} );
		},
		
		/**
		 * Install a display
		 *
		 * @since    3.0
		 * @return   null
		*/
		_installDisplay: function( e ) { 
			e.preventDefault();
			var self 			= e.data.self,
					$button 	= $( e.target ).is( 'button' ) ? $( e.target ) : $( e.target ).parents( 'button' ),
					$icon			= $button.find( 'i' ),
					iconClass	= $icon.attr( 'class' );
					
			if ( $button.hasClass( 'updating' ) ) {
				return false;
			}
			$button.addClass( 'updating' );
			$icon.attr( 'class', dittyAdminVars.updateIcon );
			
			var data = {
				action						: 'ditty_install_display',
				display_type			: $button.data( 'display_type' ),
				display_template 	: $button.data( 'display_template' ),
				display_version 	: $button.data( 'display_version' ),
				security					: dittyAdminVars.security
			};
			$.post( dittyAdminVars.ajaxurl, data, function( response ) {
				$icon.attr( 'class', iconClass );
				self.$elmt.removeClass( 'updating' );	
				if ( response ) {
					$button.replaceWith( response.button );
				}
			} );
		},
		
		/**
		 * Listen for export checkbox click
		 *
		 * @since    3.0.17
		 * @return   null
		*/
		_exportCheckboxClick: function( e ) { 
			var $checkbox 	= $( e.target ),
					$group 			= $checkbox.parents( '.ditty-input--checkboxes__group' ),
					$container 	= $checkbox.parents( '.ditty-field__input' ),
					$button			= $( '.ditty-export-button' ),
					checkboxes	= $group.find( 'input[type="checkbox"]' ),
					isChecked 	= $checkbox.is( ':checked' ),
					value 			= $checkbox.attr( 'value' );
					
			if ( 'select_all' === value ) {
				checkboxes.each( function() {
					if ( $( this )[0] !== $checkbox[0] ) {
						$( this ).prop( 'checked', isChecked );
					}
				} );
			}
			
			// Check if any checkboxes are selected
			var enableButton = false;
			checkboxes.each( function() {
				if ( $( this ).is( ':checked' ) ) {
					enableButton = true;
				}
			} );
			
			if ( enableButton ) {
				$button.attr( 'disabled', false );
			} else {
				$button.attr( 'disabled', 'disabled' );
			}	
		},

	  /**
		 * Return a specific setting
		 *
		 * @since    3.0
		 * @return   null
		*/
    _options: function ( key ) {
	    return this.settings[key];
    },
    
		/**
		 * Setup triggers
		 *
		 * @since  	3.0
		 * @return 	null
		*/
    trigger: function ( fn, customParams ) {
	    var params = [this.settings]; 
	    if ( customParams ) {
		    params = customParams;
	    }

	    this.$elmt.trigger( 'ditty_settings_' + fn, params );
	
	    if ( typeof this.settings[fn] === 'function' ) {
	      this.settings[fn].apply( this.$elmt, params );
	    }
    },
		
		/**
		 * Allow settings to be modified
		 *
		 * @since  	3.0
		 * @return 	null
		*/
    options: function ( key, value ) {

	    if ( typeof key === 'object' ) {
	      this.settings = $.extend( {}, defaults, $.ditty_settings.defaults, key );
	    } else if ( typeof key === 'string' ) {
        if ( value === undefined ) {
	        return this.settings[key];
        }
        this.settings[key] = value;
	    } else {
        return this.settings;
	    }

	    this.trigger( 'options_update' );
    },

		/**
		 * Destroy the editor
		 *
		 * @since  	3.0
		 * @return 	null
		*/
    destroy: function () {

	    // Remove listeners
			$( 'body' ).off( 'ditty_field_clone_update', { self: this }, this._enableSettingsUpdates );
			this.saveBtns.off( 'click', { self: this }, this._submitForm );
			this.tabs.off( 'click', { self: this }, this._tabClick );
			this.$panels.off( 'ditty_slider_init', { self: this }, this._sliderInit );
			this.$panels.off( 'ditty_slider_before_slide_update', { self: this }, this._beforeSlideUpdate );
			this.$form.off( 'keyup change', 'input[type="text"], input[type="number"], textarea, select', { self: this }, this._checkUpdates );
			this.$form.off( 'click', 'input[type="radio"], input[type="checkbox"]', { self: this }, this._checkUpdates );
			this.$form.off( 'ditty_input_wysiwyg_update', '.ditty-input--wysiwyg', { self: this }, this._checkUpdates );
			this.$form.off( 'click', '.ditty-default-layout-install', { self: this }, this._installLayout );
			this.$form.off( 'click', '.ditty-default-display-install', { self: this }, this._installDisplay );
			
			this.$form.off( 'click', '.ditty-export-posts input[type="checkbox"]', { self: this }, this._exportCheckboxClick );

			this.$panels.ditty_slider( 'destroy' );
	    this.elmt._ditty_settings = null;	    
    }
  };

	/**
	 * Create the data list
	 *
	 * @since  	3.0
	 * @return 	null
	*/
  $.fn.ditty_settings = function( options ) {
    var args = arguments,
        error = false,
        returns;

    if ( options === undefined || typeof options === 'object' ) {
      return this.each( function () {
        if ( ! this._ditty_settings ) {
        	this._ditty_settings = new Ditty_Settings( this, options );
        }
      });
    } else if ( typeof options === 'string' ) {
      this.each( function () {
        var instance = this._ditty_settings;

        if ( ! instance ) {
          throw new Error( 'No Ditty_Settings applied to this element.' );
        }
        if ( typeof instance[options] === 'function' && options[0] !== '_' ) {
          returns = instance[options].apply( instance, [].slice.call( args, 1 ) );
        } else {
          error = true;
        }
      } );

      if ( error ) {
        throw new Error( 'No method "' + options + '" in Ditty_Settings.' );
      }

      return returns !== undefined ? returns : this;
    }
  };

  $.ditty_settings = {};
  $.ditty_settings.defaults = defaults;

} )( jQuery );


/**
 * Ditty Extension class
 *
 * @since		3.0
 * @return	null
*/

(function ($) {
  'use strict';

  var defaults = {
  };

  var Ditty_Extension = function ( elmt, options ) {
	  
    this.elmt       = elmt;
    this.settings   = $.extend( {}, defaults, $.ditty_extension.defaults, options );
    this.$elmt      = $( elmt );
    this.$panels    = $( elmt ).find( '.ditty-extension__panels' );
    this.initPanel	= this.$panels.data( 'init_panel' );

    this._init();
  };

  Ditty_Extension.prototype = {
    
    _init: function () {
      
      // Add listeners
			this.$elmt.on( 'click', '.ditty-extension__tab', { self: this }, this._tabClick );
	    this.$elmt.on( 'click', 'button[name="submit"]', { self: this }, this._updatePanel );
	    this.$elmt.on( 'click', '.ditty-extension__license__submit', { self: this, action: 'ditty_extension_license_activate' }, this._licenseUpdate );
			this.$elmt.on( 'click', '.ditty-extension__license__refresh', { self: this, action: 'ditty_extension_license_refresh' }, this._licenseUpdate );
	    this.$elmt.on( 'click', '.ditty-extension__license__deactivate', { self: this, action: 'ditty_extension_license_deactivate' }, this._licenseUpdate );
			this.$panels.on( 'ditty_slider_before_slide_update', { self: this }, this._beforePanelUpdate );
			this._initSlider();
    },
    
    /**
		 * Initialize the slider
		 *
		 * @since    3.0
		 * @return   null
		*/
		_initSlider: function () {
			var args = {
				transition			: 'fade',
				transitionSpeed	: 0.75,
				heightSpeed			: 0.75,
				touchSwipe			: false,
				slidesEl				: '.ditty-extension__panel',
				slideId					: ( '' !== this.initPanel ) ? this.initPanel : false
			};
			this.$panels.ditty_slider( args );
		},
		
		/**
		 * Initialize the slider
		 *
		 * @since    3.0
		 * @return   null
		*/
		_beforePanelUpdate: function ( e, index, slide ) {
			var self = e.data.self;
			self.$elmt.find( '.ditty-extension__tab' ).removeClass( 'active' );
			self.$elmt.find( '.ditty-extension__tab[data-slide_id="' + slide.id + '"]' ).addClass( 'active' );
		},

		/**
		 * Tab click
		 *
		 * @since    3.0
		 * @return   null
		*/
		_tabClick: function ( e ) {
			e.preventDefault();
		  var self 					= e.data.self;
			var $tab 					= $( this ),
					slideId 			= $tab.data( 'slide_id' ),
					transition 		= 'slideLeft',
					$currentTab		= self.$elmt.find( '.ditty-extension__tab.active' );
					
			if ( $currentTab === $tab ) {
				return false;
			}

			if ( $tab.index() < $currentTab.index() ) {
				transition 	= 'slideRight';
			}

			//self.$elmt.find( '.ditty-extension__tab' ).removeClass( 'active' );
			//$tab.addClass( 'active' );
			
			self.$panels.ditty_slider( 'options', 'transition', transition );
		  self.$panels.ditty_slider( 'showSlideById', slideId );
		},
		
		/**
		 * Update inputs after save and sanitize
		 *
		 * @since    3.0.19
		 * @return   null
		*/
		_upateInputs: function( updates ) {
			$.each( updates, function( inputName, updatedValue ) {
				if ( $( 'input[name="' + inputName + '"]' ).length ) {
					$( 'input[name="' + inputName + '"]' ).val( updatedValue );
				}
			} );
		},
		
		/**
		 * Panel update listener
		 *
		 * @since    3.0.19
		 * @return   null
		*/
		_updatePanel: function ( e ) {
			e.preventDefault();
		  var self = e.data.self;

			var $button 	= $( this ),
	    		$panel		= $button.parents( '.ditty-extension__panel' ),
	    		$form			= $button.parents( '.ditty-extension__form' ),
	    		$icon			= $button.find( 'i' ),
					iconClass	= $icon.attr( 'class' ),
	    		extension = self.$elmt.data( 'extension' ),
	    		panel 		= $panel.data( 'slide_id' );
	
	    if ( self.$elmt.hasClass( 'updating' ) ) {
				return false;
			}

			self.$elmt.addClass( 'updating' );
		  $icon.attr( 'class', dittyAdminVars.updateIcon );
		  
		  $form.ajaxSubmit( {
		    url				: dittyAdminVars.ajaxurl,
				type			: 'post',
				dataType	: 'json',
				data			: {
	        action		: 'ditty_extension_panel_update',
	        extension : extension,
	        panel			: panel,
	        security	: dittyAdminVars.security
		    },
        success: function( data ) {
	        $icon.attr( 'class', iconClass );
					self.$elmt.removeClass( 'updating' );
					if ( data.input_updates ) {
						self._upateInputs( data.input_updates );
					}
					$( '#ditty-extensions' ).trigger( 'ditty_extension_panel_updated', [ data, self.$elmt, $panel ] ); 
        }
	    } );
		},
		
		/**
		 * Update a license
		 *
		 * @since    3.0
		 * @return   null
		*/
		_licenseUpdate: function ( e ) {
			e.preventDefault();
		  var self 		= e.data.self,
		  		action 	= e.data.action;
			
			var $button					= $( this ),
					$message				= self.$elmt.find( '.ditty-extension__license__message' ),
	    		$input 					= $button.siblings( '.ditty-extension__license__input' ),
	    		license 				= $input.val(),
	    		extension 			= $button.data( 'extension' ),
	    		extensionId 		= $button.data( 'extension_id' ),
	    		extensionName 	= $button.data( 'extension_name' ),
	    		$icon						= $button.children( 'i' );
	    		
	    if ( self.$elmt.hasClass( 'updating' ) ) {
				return false;
			}
	    		
	    self.$elmt.addClass( 'updating' );
			$icon.attr( 'class', dittyAdminVars.updateIcon );

	    // Load the new display data		
			var data = {
				action					: action,
				license					: license,
				extension				: extension,
				extension_id		: extensionId,	
				extension_name	: extensionName,
				security				: dittyAdminVars.security
			};	
	    $.post( dittyAdminVars.ajaxurl, data, function( response ) {
		    if ( response ) {
			    self.$elmt.attr( 'data-license_status', response.status );
			    $message.html( response.message );
		    }
				if ( response.license_key ) {
					if ( 'DELETE' === response.license_key ) {
						$input.val( '' );
					} else {
						$input.val( response.license_key );
					}
				}
		    $icon.attr( 'class', $icon.data( 'class' ) );
		    self.$elmt.removeClass( 'updating' );
			}, 'json' );
		},
		
    /**
		 * Return data for the object
		 *
		 * @since    3.0
		 * @return   null
		*/
    _getOption: function( key ) {
	    switch( key ) {
				default:
					return this.settings[key];
	    }
    },
    
    /**
		 * Set data for the object
		 *
		 * @since    3.0
		 * @return   null
		*/
    _setOption: function( key, value ) {  
			if ( undefined === value ) {
				return false; 
			}

	    this.settings[key] = value;
    },
		
		/**
		 * Get or set ditty options
		 *
		 * @since    3.0
		 * @return   null
		*/
    options: function ( key, value ) {
	    var self = this;
	    if ( typeof key === 'object' ) {   
		    $.each( key, function( k, v ) {
			    self._setOption( k, v );
				});  
	    } else if ( typeof key === 'string' ) {
        if ( value === undefined ) {
	        return self._getOption( key );
        }
        self._setOption( key, value );
	    } else {
        return self.settings;
	    }
    },
		
		/**
		 * Destroy this object
		 *
		 * @since    3.0
		 * @return   null
		*/
    destroy: function () {
			// Remove listeners
			this.$elmt.off( 'click', '.ditty-extension__tab', { self: this }, this._tabClick );
			this.$elmt.off( 'click', 'button[name="submit"]', { self: this }, this._updatePanel );
			this.$elmt.off( 'click', '.ditty-extension__license__submit, .ditty-extension__license__refresh', { self: this, action: 'ditty_extension_license_activate' }, this._licenseUpdate );
			this.$elmt.off( 'click', '.ditty-extension__license__deactivate', { self: this, action: 'ditty_extension_license_deactivate' }, this._licenseUpdate );
			this.$panels.off( 'ditty_slider_after_slide_update', { self: this }, this._afterPanelUpdate );
			
	    this.$panels.ditty_slider( 'destroy' );
	    this.elmt._ditty_extension = null;
    }
  };

  $.fn.ditty_extension = function( options ) {
    var args = arguments,
        error = false,
        returns;

    if ( options === undefined || typeof options === 'object' ) {
      return this.each( function () {
        if ( ! this._ditty_extension ) {
        	this._ditty_extension = new Ditty_Extension( this, options );
        }
      });
    } else if ( typeof options === 'string' ) {
      this.each( function () {
        var instance = this._ditty_extension;

        if ( ! instance ) {
          throw new Error( 'No Ditty_Extension applied to this element.' );
        }
        if ( typeof instance[options] === 'function' && options[0] !== '_' ) {
          returns = instance[options].apply( instance, [].slice.call( args, 1 ) );
        } else {
          error = true;
        }
      } );

      if ( error ) {
        throw new Error( 'No method "' + options + '" in Ditty_Extension.' );
      }

      return returns !== undefined ? returns : this;
    }
  };

  $.ditty_extension = {};
  $.ditty_extension.defaults = defaults;

} )( jQuery );



jQuery( function( $ ) {	
	// Setup strict mode
	(function() {

    "use strict";
    
    // Setup protip
		$.protip( {
			defaults: {
				position: 'top',
				size: 'small',
				scheme: 'black',
				classes: 'ditty-protip'
			}
		} );

		/**
		 * Listen for an accordion toggle click
		 *
		 * @since    3.0
		 * @return   null
		*/
		// $( '#ditty-extensions' ).on( 'click', '.ditty-accordion__toggle', function( e ) {
		// 	e.preventDefault();
		// 	var $accordion = $( this ).parent(),
		// 			$content = $( this ).next();
		// 			
		// 	if ( $accordion.hasClass( 'active' ) ) {
		// 		$accordion.removeClass( 'active' );
		// 		$content.stop().slideUp( { duration: 750, easing: "easeInOutQuint" } );
		// 	} else {
		// 		$accordion.addClass( 'active' );
		// 		$content.stop().slideDown( { duration: 750, easing: "easeInOutQuint" }, function() {
		// 			$content.css( 'height', 'auto' );
		// 		} );
		// 	}
		// } );
		// 
    /**
		 * Initialize the extensions
		 *
		 * @since    3.0
		 * @return   null
		*/
		function ditty_extensions_init() {
			$( '#ditty-extensions' ).find( '.ditty-extension' ).each( function( index ) {	

				var $extension = $( this ),
						$panels = $extension.find( '.ditty-extension__panels' );
				
				if ( $panels.length ) {
					$extension.ditty_extension();
				}
				
				$( '#ditty-extensions' ).trigger( 'ditty_init_fields' );
				
				setTimeout( function() {
					$extension.addClass( 'ditty-extension--init' );
				}, index * 250 );
						
			} );
		}
		ditty_extensions_init();

	}() );
	
} );

jQuery(function($) {
	// Setup strict mode
	(function() {
		'use strict';

		var isDisplayPost = $('input[name="post_type"]').length && 'ditty_display' == $('input[name="post_type"]').val(),
			ajaxSubmitComplete = false;

		$('form#post').on('submit', function(e) {
			if (isDisplayPost && !ajaxSubmitComplete) {
				if (!$('#auto_draft').length) {
					e.preventDefault();

					var $button = $('#publishing-action').children('input[type="submit"]'),
						$spinner = $('#publishing-action').children('.spinner');

					$button.attr('disabled', 'disabled');
					$spinner.css('visibility', 'visible');

					var data = {
						action: 'ditty_admin_display_update',
						display_id: $('input[name="post_ID"]').val(),
						security: dittyAdminVars.security,
					};
					$('#ditty-display-settings').ajaxSubmit({
						url: dittyAdminVars.ajaxurl,
						type: 'post',
						dataType: 'json',
						data: data,
						success: function(response) {
							ajaxSubmitComplete = true;
							$('form#post').submit();
						},
					});
				}
			}
		});
	})();
});



jQuery( function( $ ) {	
	// Setup strict mode
	(function() {

    "use strict";
		
		var dittyWizardValues = {};
		
		/**
		 * Ditty title
		 *
		 * @since    3.0.13
		*/
		$( '.ditty-wizard-setting--title input[name="ditty_title"]' ).on( 'keyup', function() {
			var $setting = $( this ).parents( '.ditty-wizard-setting' ),
					val = $( this ).val();
					
			if ( '' !== val ) {
				$setting.addClass( 'complete' );
				
				// Show the layout settings
				$( '.ditty-wizard-setting--item-type').css( 'display', 'flex' );
			}
			dittyWizardValues.title = val;
		} );
		
		/**
		 * Item Type
		 *
		 * @since    3.0.13
		*/
		$( '.ditty-wizard-setting--item-type .ditty-option-grid__item' ).on( 'click', function( e ) {
			e.preventDefault();
			var $setting = $( this ).parents( '.ditty-wizard-setting' ),
					slug = $( this ).data( 'value' );

			if ( ! $( this ).hasClass( 'active' ) ) {

				$( this ).siblings().removeClass( 'active' );
				$( this ).addClass( 'active' );

				// Reset & show item type settings
				$( '.ditty-wizard-setting--item-type-settings' ).removeClass( 'complete' );
				$( '.ditty-wizard-setting--item-type-settings .ditty-option-submit' ).addClass( 'ditty-button--primary' );
				$( '.ditty-wizard-setting--item-type-settings').css( 'display', 'flex' );
				
				// Display the correct item type settings group
				var $itemSettings = $( '.ditty-item-type-settings__group[data-id="' + slug + '"]' );
				$( '.ditty-item-type-settings__group' ).removeClass( 'active' ).hide();
				$itemSettings.addClass( 'active' ).show();
				$itemSettings.trigger( 'ditty_init_fields' );
				if ( ! $itemSettings.hasClass( 'init' ) ) {
					$itemSettings.trigger( 'ditty_wizard_init', [slug] );
					$itemSettings.addClass( 'init' );
				}
				
				// Reset the layout settings
				$( '.ditty-wizard-setting--layout' ).removeClass( 'complete' );
				$( '.ditty-wizard-setting--layout .ditty-option-grid__item' ).removeClass( 'active' );
				$( '.ditty-wizard-setting--layout').hide();
				
				// Display the correct layout variation settings group
				$( '.ditty-wizard-setting--layout__variation' ).removeClass( 'complete' ).removeClass( 'active' ).hide();
				$( '.ditty-wizard-setting--layout__variation.' + slug ).addClass( 'active' ).show();
				
				// Reset the display settings
				$( '.ditty-wizard-setting--display' ).removeClass( 'complete' );
				$( '.ditty-wizard-setting--display .ditty-option-grid__item' ).removeClass( 'active' );
				$( '.ditty-wizard-setting--display').hide();
				
				// Reset the submit settings
				$( '.ditty-wizard-setting--submit').hide();
				
				// Add to the initialize object
				dittyWizardValues.itemType = $( this ).data( 'value' );
				
				// Animate to the next setting
				if ( ! $setting.hasClass( 'complete' ) ) {
					$setting.addClass( 'complete' );
					$( [document.documentElement, document.body] ).stop().animate( {
						scrollTop: $( '.ditty-wizard-setting--item-type-settings' ).offset().top
					}, 700 );
				}
			}
		} );
		
		/**
		 * Item Type Settings Submit
		 *
		 * @since    3.0.13
		*/
		$( '.ditty-wizard-setting--item-type-settings .ditty-option-submit' ).on( 'click', function( e ) {
			e.preventDefault();
			var $setting = $( this ).parents( '.ditty-wizard-setting' ),
					$settings_group = $setting.find( '.ditty-item-type-settings__group.active' ),
					values = {};
					
			$( this ).removeClass( 'ditty-button--primary' );

			$settings_group.find( ':input' ).each( function() {
				var type = $( this ).prop( 'type' );
		
				// checked radios/checkboxes
				if ( ( type === "checkbox" || type === "radio" ) ) { 
					if (  this.checked ) {
						values[$( this ).attr( 'name' )] = $( this ).val();
					}
				} else if ( type !== "button" && type !== "submit" ) {
					values[$( this ).attr( 'name' )] = $( this ).val();
				}
			} );
			
			// Show the layout settings
			$( '.ditty-wizard-setting--layout').css( 'display', 'flex' );
			
			// Add to the initialize object
			dittyWizardValues.itemTypeValues = values;
			
			// Animate to the next setting
			if ( ! $setting.hasClass( 'complete' ) ) {
				$setting.addClass( 'complete' );
				$( [document.documentElement, document.body] ).stop().animate( {
					scrollTop: $( '.ditty-wizard-setting--layout' ).offset().top
				}, 700 );
			}
		} );
		
		/**
		 * Variation Layout
		 *
		 * @since    3.0.13
		*/
		$( '.ditty-wizard-setting--layout .ditty-option-grid__item' ).on( 'click', function( e ) {
			e.preventDefault();
			var $setting = $( this ).parents( '.ditty-wizard-setting' ),
					$variations = $( this ).parents( '.ditty-wizard-setting--layout__variation' );
		
			if ( ! $( this ).hasClass( 'active' ) ) {		
				$( this ).siblings().removeClass( 'active' );
				$( this ).addClass( 'active' );
				$variations.addClass( 'complete' );
				
				// Check for all variations complete
				if ( $( '.ditty-wizard-setting--layout__variation.active' ).length === $( '.ditty-wizard-setting--layout__variation.complete' ).length ) {
					var layoutVariations = {};
					$( '.ditty-wizard-setting--layout__variation.complete' ).each( function() {
						layoutVariations[$( this ).data( 'id' )] = $( this ).find( '.ditty-option-grid__item.active' ).data( 'value' );
					} );
					
					// Show the display settings
					$( '.ditty-wizard-setting--display').css( 'display', 'flex' );
					
					dittyWizardValues.layoutVariations = layoutVariations;
					
					// Animate to the next setting
					if ( ! $setting.hasClass( 'complete' ) ) {
						$setting.addClass( 'complete' );
						$( [document.documentElement, document.body] ).stop().animate( {
							scrollTop: $( '.ditty-wizard-setting--display' ).offset().top
						}, 700 );
					}
				}
			}
		} );
		
		/**
		 * Display
		 *
		 * @since    3.0.13
		*/
		$( '.ditty-wizard-setting--display .ditty-option-grid__item' ).on( 'click', function( e ) {
			e.preventDefault();
			var $setting = $( this ).parents( '.ditty-wizard-setting' ),
					id = $( this ).data( 'value' );
		
			if ( ! $( this ).hasClass( 'active' ) ) {		
				$( this ).siblings().removeClass( 'active' );
				$( this ).addClass( 'active' );
				
				// Show the submit settings
				$( '.ditty-wizard-setting--submit').css( 'display', 'flex' );
				
				dittyWizardValues.display = id;
				
				// Animate to the next setting
				if ( ! $setting.hasClass( 'complete' ) ) {
					$setting.addClass( 'complete' );
					$( [document.documentElement, document.body] ).stop().animate( {
						scrollTop: $( '.ditty-wizard-setting--submit' ).offset().top
					}, 700 );
				}
			}
		} );
		
		/**
		 * Submit the wizard
		 *
		 * @since    3.0.13
		*/
		$( '#ditty-wizard-submit' ).on( 'click', function( e ) {
			e.preventDefault();
			
			var dittyId = $( this ).data( 'ditty_id' );
			
			$( '#ditty-wizard-overlay' ).addClass( 'active' );
			
			//$( this ).text( $( this ).data( 'submitting' ) );
			
			var data = {
				action				: 'ditty_submit_wizard',
				ditty_id			: dittyId,
				init_values 	: dittyWizardValues,
				security			: dittyVars.security
			};
			$.post( dittyVars.ajaxurl, data, function( response ) {
				window.history.pushState( null, '', '/wp-admin/post.php?post=' + dittyId + '&action=edit' );
				location.reload();
			}, 'json' );

		} );
		
	}() );
	
} );