<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Digeco_Core;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit;

class Contact_Address extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'RT Contact Address', 'digeco-core' );
		$this->rt_base = 'rt-contact-address';
		parent::__construct( $data, $args );
	}

	public function rt_fields(){

		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => esc_html__( 'General', 'digeco-core' ),
			),
			array(
				'type'    => Controls_Manager::SWITCHER,
				'id'      => 'animation_display',
				'label'   => esc_html__( 'Animation Off/On', 'digeco-core' ),
				'default' => 'yes',
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'delay',
				'label'   => esc_html__( 'Animation Delay', 'digeco-core' ),
				'default' => '100',
				'condition'   => array( 'animation_display' => array( 'yes' ) ),
			),			
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'style',
				'label'   => esc_html__( 'Theme Style', 'digeco-core' ),
				'options' => array(
					'light' => esc_html__( 'Light Background', 'digeco-core' ),
					'dark'  => esc_html__( 'Dark Background', 'digeco-core' ),
				),
				'default' => 'light',
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'    => 'address_title',
				'label'   => esc_html__( 'Address Tile', 'digeco-core' ),
				'default' => 'Our Office Address',
			),
			array (
				'type'    => Controls_Manager::REPEATER,
				'id'      => 'address_info',
				'label'   => esc_html__( 'Address', 'digeco-core' ),
				'fields'  => array(
					array(
						'type'    => Controls_Manager::TEXTAREA,
						'name'    => 'address_icon',
						'label'   => esc_html__( 'Address Icon', 'digeco-core' ),
						'default' => '<i class="flaticon-mail"></i>',
					),
					array(
						'type'    => Controls_Manager::TEXT,
						'name'    => 'address_label',
						'label'   => esc_html__( 'Address Label', 'digeco-core' ),
						'default' => 'Office Name',
					),
					array(
						'type'    => Controls_Manager::TEXTAREA,
						'name'    => 'address_infos',
						'label'   => esc_html__( 'Add Address', 'digeco-core' ),
						'default' => '29 Street, Melbourne City<br>example@gmail.com<br><a href="tel:+0123456789">+0123456789</a> ',
					),
				),
			),
			
			array(
				'mode' => 'section_end',
			),
		);
		return $fields;
	}
		
	protected function render() {
			
		$data = $this->get_settings();
		
		$template = 'contact-address';

		return $this->rt_template( $template, $data );
	}
}